package ie.ucd.sixth.adaptor.davis;

import org.osgi.framework.BundleContext;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import ie.ucd.sixth.core.adaptor.AbstractSensorNetworkAdaptor;
import ie.ucd.sixth.core.misc.IConnectivityReceiver;
import ie.ucd.sixth.core.misc.TaskingMessage;
import ie.ucd.sixth.core.sensor.SensorDescription;
import ie.ucd.sixth.core.sensor.SensorMessage;
import ie.ucd.sixth.core.sensor.SensorNodeDescription;
import ie.ucd.sixth.core.sensor.data.Modality;

public class DavisAdaptor extends AbstractSensorNetworkAdaptor implements
		IConnectivityReceiver, SerialPortEventListener {

	private int baudRate = 19200;

	public DavisAdaptor(BundleContext bundleContext) {

		this.baudRate = 19200;
		initialize("davis");
		CommPortIdentifier portID;
		try {
			portID = CommPortIdentifier.getPortIdentifier("COM3");
			new SerialPortComm(portID, baudRate, this);
		} catch (NoSuchPortException e) {
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public void setNodeTypes() {
		String type = getName();
		SensorNodeDescription desc = new SensorNodeDescription(000, type);
		desc.addSensor(new SensorDescription(Modality.Barometer, 000, type));
		desc.addSensor(new SensorDescription(Modality.TempInside, 000, type));
		desc.addSensor(new SensorDescription(Modality.HumInside, 000, type));
		desc.addSensor(new SensorDescription(Modality.TempOutside, 000, type));
		desc.addSensor(new SensorDescription(Modality.WindSpeed, 000, type));
		desc.addSensor(new SensorDescription(new Modality("Battery"), 000, type));
		desc.addSensor(new SensorDescription(Modality.WindSpeed10min, 000, type));
		desc.addSensor(new SensorDescription(Modality.WindDir, 000, type));
		desc.addSensor(new SensorDescription(Modality.HumOutside, 000, type));
		desc.addSensor(new SensorDescription(Modality.Rain, 000, type));
		desc.addSensor(new SensorDescription(Modality.UV, 000, type));
		desc.addSensor(new SensorDescription(new Modality("Battery" + ".rate"),
				000, type));

		desc.addSensor(new SensorDescription(Modality.SolarRad, 000, type));
		desc.addSensor(new SensorDescription(Modality.Storm, 000, type));
		desc.addSensor(new SensorDescription(Modality.dayRain, 000, type));
		desc.addSensor(new SensorDescription(Modality.monthRain, 000, type));
		desc.addSensor(new SensorDescription(Modality.yearRain, 000, type));
		desc.addSensor(new SensorDescription(Modality.sunRise, 000, type));
		desc.addSensor(new SensorDescription(Modality.sunSet, 000, type));
		nodeTypeMap.put(type + ".sensor", desc);
	}

	@Override
	public void accept(SensorMessage visitor) {
		// TODO Auto-generated method stub

		SensorMessage message = (SensorMessage) visitor;
		String address = message.getSensor();
		if (isDavis(address)) {
			System.out.println("Davis Weather Station: " + visitor.getSensor());
			CommPortIdentifier portID;
			try {
				portID = CommPortIdentifier.getPortIdentifier(address);
				new SerialPortComm(portID, baudRate, this);
			} catch (NoSuchPortException e) {
				e.printStackTrace();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	public static boolean isDavis(String path) {
		String os = System.getProperty("os.name");
		if (os.startsWith("win")) {
			return path.startsWith("COM3");
		} else {
			return false;
		}
	}

	@Override
	public void serialEvent(SerialPortEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean task(TaskingMessage taskingMessage) {
		// TODO Auto-generated method stub
		return false;
	}

}
